/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;

public abstract class EntityAbstractSwimmingBird
extends EntityAbstractBird {
    public EntityAbstractSwimmingBird(EntityType<? extends EntityAbstractBird> type, World worldIn, ItemStack itemEggIn, int typesCountIn, boolean canFloatIn, boolean isGenderedIn) {
        super(type, worldIn, itemEggIn, typesCountIn, canFloatIn, isGenderedIn);
        this.field_70765_h = new MoveHelperController(this);
        this.func_70661_as().func_212239_d(true);
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return ExoticBirdsEntities.WATER_BIRD;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public static boolean canAnimalSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return (worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) || worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150355_j)) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityAbstractSwimmingBird birdEntity;

        MoveHelperController(EntityAbstractSwimmingBird entityIn) {
            super((MobEntity)entityIn);
            this.birdEntity = entityIn;
        }

        private void updateSpeed() {
            if (this.birdEntity.func_70090_H()) {
                if (this.birdEntity.func_233571_b_((ITag)FluidTags.field_206959_a) > (double)this.birdEntity.func_213302_cg() * 0.4) {
                    this.birdEntity.func_213317_d(this.birdEntity.func_213322_ci().func_72441_c(0.0, 0.05, 0.0));
                }
                this.birdEntity.func_70659_e(1.6f);
            } else {
                this.birdEntity.func_70659_e(0.2f);
            }
        }

        public void func_75641_c() {
            this.updateSpeed();
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.func_226277_ct_();
                double d1 = this.field_75644_d - this.field_75648_a.func_226281_cx_();
                double d2 = this.field_75647_c - this.field_75648_a.func_226278_cu_();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f9 = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f9, 90.0f);
                float f1 = (float)(this.field_75645_e * this.field_75648_a.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                this.birdEntity.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.birdEntity.func_70689_ay(), (float)f1));
                int i = MathHelper.func_76128_c((double)this.field_75648_a.func_226277_ct_());
                int j = MathHelper.func_76128_c((double)(this.field_75648_a.func_226278_cu_() - (double)0.2f));
                int k = MathHelper.func_76128_c((double)this.field_75648_a.func_226281_cx_());
                BlockPos blockpos = new BlockPos(i, j, k);
                BlockState blockstate = this.field_75648_a.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)this.field_75648_a.field_70170_p, blockpos);
                if (d2 > (double)this.field_75648_a.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_75648_a.func_213311_cf()) || !voxelshape.func_197766_b() && this.field_75648_a.func_226278_cu_() < voxelshape.func_197758_c(Direction.Axis.Y) + (double)blockpos.func_177956_o() && !block.func_203417_a((ITag)BlockTags.field_200029_f) && !block.func_203417_a((ITag)BlockTags.field_219748_G)) {
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_188491_h = MovementController.Action.JUMPING;
                }
            } else {
                super.func_75641_c();
            }
        }
    }
}

